#!/bin/sh

set -e

# create .env file
cp -pv .env.example .env

echo "create an environment..."
python3 -m venv venv

echo "installing python requirements..."
./venv/bin/pip install wheel
./venv/bin/pip install -r requirements.txt --no-cache-dir

# Applying migrations
./venv/bin/python3 manage.py migrate --skip-checks

echo "Applying seeds..."
./venv/bin/python3 manage.py loaddata app/seeds/settings.json
./venv/bin/python3 manage.py loaddata app/seeds/pages.json
./venv/bin/python3 manage.py loaddata app/seeds/admin_interface.json
./venv/bin/python3 manage.py loaddata app/seeds/auth.json

echo "Handling assets/static files..."
./venv/bin/python3 manage.py collectstatic --no-input --skip-checks

echo "Installation completed successfully.";

# Server restart is required!
